/**
 * Display details for a specific warning.
 */
WCF.Infraction.Warning.ShowSelfDetails = WCF.Infraction.Warning.ShowDetails.extend({
    /**
     * Handles clicks on the details link.
     *
     * @param	object		event
     */
    _click: function(event) {
        var $userWarningID = $(event.currentTarget).parents('.jsWarningRow').data('objectID');

        if (this._cache[$userWarningID] === undefined) {
            this._proxy.setOption('data', {
                actionName: 'getDetails',
                className: 'wcf\\data\\user\\infraction\\warning\\UserSelfInfractionWarningAction',
                objectIDs: [ $userWarningID ]
            });
            this._proxy.sendRequest();
        }
        else {
            this._showDetails($userWarningID);
        }

        event.preventDefault();
        return false;
    }
});