<?php
namespace wcf\system\menu\user\profile\content;
use wcf\data\user\infraction\warning\UserInfractionWarningList;
use wcf\data\user\infraction\warning\ViewableUserInfractionWarningList;
use wcf\system\WCF;

/**
 * Shows user warning list for the user
 *
 * @author        Olaf Braun
 * @copyright     2016 Olaf Braun - Software Development
 *
 * @package       wcf\system\menu\user\profile\content
 */
class UserWarningUserProfileMenuContent extends WarningUserProfileMenuContent{

	/**
	 * @see	\wcf\system\menu\user\profile\content\IUserProfileMenuContent::getContent()
	 */
	public function getContent($userID) {
		$userWarningList = new ViewableUserInfractionWarningList();
		$userWarningList->getConditionBuilder()->add("user_infraction_warning.userID = ?", array($userID));
		$userWarningList->sqlOrderBy = "user_infraction_warning.time DESC";
		$userWarningList->readObjects();

		WCF::getTPL()->assign(array(
			'warningList' => $userWarningList
		));
		return WCF::getTPL()->fetch('selfUserWarningList');
	}
	/**
	 * @see	\wcf\system\menu\user\profile\content\IUserProfileMenuContent::isVisible()
	 */
	public function isVisible($userID) {
		if ($this->visible === null) {
			$this->visible = false;

			if (!WCF::getSession()->getPermission('mod.infraction.warning.canWarn') && WCF::getUser()->getUserID() == $userID) {
				// count warnings
				$userWarningList = new UserInfractionWarningList();
				$userWarningList->getConditionBuilder()->add("user_infraction_warning.userID = ?", array($userID));
				if ($userWarningList->countObjects()) $this->visible = true;
			}
		}

		return $this->visible;
	}
}