<?php
namespace wcf\data\user\infraction\warning;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\exception\UserInputException;
use wcf\system\WCF;

/**
 *
 *
 * @author        Olaf Braun
 * @copyright     2016 Olaf Braun - Software Development
 *
 * @package       wcf\data\user\infraction\warning
 */
class UserSelfInfractionWarningAction extends UserInfractionWarningAction{

	/**
	 * Validates parameters to show details of a warning.
	 */
	public function validateGetDetails(){
		if(WCF::getSession()->getPermission('mod.infraction.warning.canWarn')){
			throw new PermissionDeniedException();
		}

		$this->warningEditor = $this->getSingleObject();
		if(!$this->warningEditor->userWarningID){
			throw new UserInputException('objectIDs');
		}
		if($this->warningEditor->userID != WCF::getUser()->getUserID()){
			throw new PermissionDeniedException();
		}
	}

}