<?php
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');
require_once(WCF_DIR.'lib/data/message/bbcode/MessageParser.class.php');

class IndexPageGlobalannounceListener implements EventListener
{
	public $templateName = 'globalannounce';

	public function execute($eventObj, $className, $eventName)
	{
		if(WCF::getUser()->getPermission('user.board.canSeeGlobalannounce'))
		{
			$announcetext = MessageParser::getInstance()->parse(COM_INDEX_GLOBALANNOUNCE_TEXT, COM_INDEX_ENABLESMILIES, COM_INDEX_ENABLEHTML, COM_INDEX_ENABLEBBCODE, false);

			WCF::getTPL()->assign('global_announce_text', $announcetext);
			WCF::getTPL()->assign('permission_global_announce_text', 1);

			if (strpos(WCF::getTPL()->get('userMessages'), $announcetext) === false)
			{
				WCF::getTPL()->append('userMessages', WCF::getTPL()->fetch('globalannounce'));
			}
		}
	}
}
?>