<?php
namespace news\system\event\listener;
use news\data\entry\AccessibleEntryList;
use wcf\system\WCF;
use wcf\system\application\ApplicationHandler;
use wcf\system\event\IEventListener;

/**
 * @author 	Tino Stange
 * @package	eu.t1n0.newsExtendedSearch
 */
class NewsExtendedSearchActionListener implements IEventListener {
	private $eventObj = null;

	/**
	 * @see	\wcf\system\event\IEventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		$this->eventObj = $eventObj;
		$this->eventObj->data['newsEntries'] = $this->getEntries();
	}

	/**
	 * Selects all matching news entries from the database
	 * @return array    the matching news entries
	 */
	private function getEntries() {
		// don't have permissions to access any news entry
		if (!WCF::getSession()->getPermission('user.news.canReadEntry')) {
			return array();
		}

		$entryList = new AccessibleEntryList();
		$entryList->getConditionBuilder()->add('subject LIKE ?', array($this->eventObj->getSearchString(EXTENDED_SEARCH_SEARCH_NEWS_TYPE)));
		$entryList->sqlOrderBy = EXTENDED_SEARCH_SEARCH_NEWS_ORDER . ' ' . EXTENDED_SEARCH_SEARCH_NEWS_ORDER_SORT;
		$entryList->sqlLimit = EXTENDED_SEARCH_SEARCH_NEWS_COUNT;
		$entryList->readObjects();
		
		$entries = array();
		$entries['title'] = WCF::getLanguage()->get('news.extendedSearch.type.entries');
		$entries['position'] = 'right';

		// if the current application is correct, we want to display the results at the top, so set a nice value of 1
		$activeApplicationAbbr = ApplicationHandler::getInstance()->getActiveApplication()->getAbbreviation();
		if ($activeApplicationAbbr === 'news') {
			$entries['niceValue'] = 1;
		}

		$entries['data'] = array();
		$count = 0;
		foreach ($entryList->getObjects() as $entry) {
			$count++;
			$entries['data'][$count] = array(
				'label' => $entry->subject,
				'link' => $entry->getLink(),
				'hitCount' => $entry->views
			);

			if (EXTENDED_SEARCH_SEARCH_NEWS_PATH) {
				$entries['data'][$count]['path'] = $this->getPath($entry->getCategories());
			}
		}

		return $entries;
	}

	private function getPath($categories) {
		$path = '';
		$i = 0;
		$categoryCount = count($categories);

		foreach ($categories as $category) {
			$i++;
			$path .= WCF::getLanguage()->get($category->title);

			if ($categoryCount > 1 && $i != $categoryCount) {
				$path .= " > ";
			}
		}

		return $path;
	}
}