#!/bin/bash
#
# Install script for the Pushxx socket server.
#
# Requires systemd!
#

# Make sure only root can run our script
if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root" 1>&2;
   exit 1;
fi

echo "Creating user";

groupadd push;
useradd -r -g push push;

echo "Copying files...";
cp pushxx /usr/local/bin/pushxx;
cp -n pushxx.conf /etc/pushxx.conf || true;
cp pushxx.service /etc/systemd/system/pushxx.service;

chown root:root /usr/local/bin/pushxx;
chmod 755 /usr/local/bin/pushxx;

chown root:root /etc/systemd/system/pushxx.service;
chmod 644 /etc/systemd/system/pushxx.service;

chown root:root /etc/pushxx.conf;
chmod 644 /etc/pushxx.conf;

touch /var/log/push.log;
chown push:push /var/log/push.log;
chmod 0644 /var/log/push.log;

echo "Reloading systemd daemon";
systemctl daemon-reload;
systemctl enable pushxx.service;

echo "Done!";
echo "";
echo "Please open the configuration file '/etc/pushxx.conf' and enter your secret key.";
echo "You can generate your secret key in your plugins's WCF/WSC option page.";
echo "";
echo "Without secret key, the push server does NOT start.";
echo "";
echo "To start the socket server run 'systemctl start pushxx' as root.";