#!/bin/bash

# Make sure only root can run our script
if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root" 1>&2;
   exit 1;
fi

echo "Stopping service...";
systemctl stop pushxx;
echo "Service stopped.";

echo "Uninstalling service...";
systemctl disable pushxx.service;
rm /etc/systemd/system/pushxx.service;
systemctl daemon-reload;

echo "Removing files...";
rm /etc/pushxx.conf;
rm /usr/local/bin/pushxx;
rm /var/log/push.log;

echo "Removing user...";
userdel -r push;
groupdel push;

echo "Done.";