#!/bin/bash
#
# Update script for the Pushxx socket server.
#
# Requires systemd!
#

# Make sure only root can run our script
if [[ $EUID -ne 0 ]]; then
   echo "This script must be run as root" 1>&2;
   exit 1;
fi

echo "Stopping service...";
systemctl stop pushxx;
echo "Service stopped.";

echo "Copying files...";
cp pushxx /usr/local/bin/pushxx;
cp pushxx.conf /etc/pushxx.conf.new;
cp pushxx.service /etc/systemd/system/pushxx.service;

chown root:root /usr/local/bin/pushxx;
chmod 755 /usr/local/bin/pushxx;

chown root:root /etc/systemd/system/pushxx.service;
chmod 644 /etc/systemd/system/pushxx.service;

chown root:root /etc/pushxx.conf;
chmod 644 /etc/pushxx.conf;

touch /var/log/push.log;
chown push:push /var/log/push.log;
chmod 0644 /var/log/push.log;

echo "Reloading systemd daemon";
systemctl daemon-reload;
systemctl enable pushxx.service;

echo "Starting service...";
systemctl start pushxx;

echo "Done!";
echo "";
echo "A new copy of the example configuration can be found under '/etc/pushxx.conf.new'.";
echo "Your old configuration file ('/etc/pushxx.conf') was not touched during the update process.";