{capture assign='pageTitle'}{$__wcf->getActivePage()->getTitle()}{/capture}

{capture assign='headContent'}
	{event name='javascriptInclude'}
	<script data-relocate="true">
        require(['WoltLabSuite/Core/Language'], function (Language) {
            Language.addObject({
                'wcf.attachment.upload.error.invalidExtension': '{lang}wcf.attachment.upload.error.invalidExtension{/lang}',
                'wcf.attachment.upload.error.tooLarge': '{lang}wcf.attachment.upload.error.tooLarge{/lang}',
                'wcf.attachment.upload.error.uploadFailed': '{lang}wcf.attachment.upload.error.uploadFailed{/lang}',
                'wcf.attachment.upload.error.noImage': '{lang}wcf.media.upload.error.noImage{/lang}',
                'de.wbb-elite.news.preview.confirmOverwrite': '{lang}de.wbb-elite.news.preview.confirmOverwrite{/lang}',
                'de.wbb-elite.news.previewImage.delete.sure': '{lang}de.wbb-elite.news.previewImage.delete.sure{/lang}',
                'wcf.media.chooseImage': '{lang}wcf.media.chooseImage{/lang}',
                'wcf.media.manager': '{lang}wcf.media.manager{/lang}',
                'wcf.label.none': '{lang}wcf.label.none{/lang}'
				{if DE_WBB_ELITE_NEWS_SOURCE_ENABLE&& $__wcf->getSession()->getPermission("user.news.canAddSource")}
                , 'de.wbb-elite.news.sources.addSource': '{lang}de.wbb-elite.news.sources.addSource{/lang}',
                'de.wbb-elite.news.sources.removeSource': '{lang}de.wbb-elite.news.sources.removeSource{/lang}',
                'wcf.global.button.delete': '{lang}wcf.global.button.delete{/lang}',
                'de.wbb-elite.news.sources.input.link': '{lang}de.wbb-elite.news.sources.input.link{/lang}',
                'de.wbb-elite.news.sources.input.title': '{lang}de.wbb-elite.news.sources.input.title{/lang}'
				{/if}
            });
        });
	</script>
	<style type="text/css">
		.previewImage > img {
			max-height: {@DE_WBB_ELITE_NEWS_SHOW_PREVIEW_MAX_HEIGHT}px;
			max-width: {@DE_WBB_ELITE_NEWS_SHOW_PREVIEW_MAX_WIDTH}px;
			margin-bottom: 5px
		}
	</style>
{/capture}
{include file='header'}
{include file='formError'}
<form id="messageContainer" class="jsFormGuard" method="post"
      action="{if $action == 'add'}{link application='news' controller='NewsAdd'}{/link}{else}{link application='news' controller='NewsEdit' id=$newsID}{/link}{/if}">

	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.category.list{/lang}</h2>
		{if DE_WBB_ELITE_NEWS_SHOW_CATEGORY_LIST_NEWS_ADD}
			<dl>
				<dt><label for="categoryIDs"></label></dt>
				<dd>
					<select id="categoryIDs" name="categoryIDs[]" multiple="multiple"
					        size="10">
						{foreach from=$categories key=key item=category}
							{if $category->canUseCategory()}
								<option value="{$category->categoryID}"{if $category->categoryID|in_array:$categoryIDs} selected="selected"{/if}>{$category->getTitle()|language}</option>
								{if $category->hasChildren()}
									{foreach from=$category item=parentCategory}
										{if $parentCategory->canUseCategory()}
											<option value="{$parentCategory->categoryID}"{if $parentCategory->categoryID|in_array:$categoryIDs} selected="selected"{/if}>
												&nbsp;&nbsp;&nbsp;&nbsp;{$parentCategory->getTitle()|language}</option>
										{/if}
									{/foreach}
								{/if}
							{/if}
						{/foreach}
					</select>
				</dd>
			</dl>
		{else}
			{hascontent}
				<ol id="flexibleCategoryList" class="flexibleCategoryList">
					{content}
					{foreach from=$categories item=category}
						{if $category->canUseCategory()}
							<li>
								<div class="containerHeadline">
									<h3>
										<label>
											<input class="jsCategory"{if $category->categoryID|in_array:$categoryIDs} checked="checked"{/if}
											       type="checkbox" value="{$category->categoryID}"
											       name="categoryIDs[]"/>
											{$category->getTitle()|language}
										</label>
									</h3>
								</div>
								{if $category->hasChildren()}
									<ol>
										{foreach from=$category item=parentCategory}
											{if $parentCategory->canUseCategory()}
												<li>
													<label>
														<input class="jsChildCategory"{if $parentCategory->categoryID|in_array:$categoryIDs} checked="checked"{/if}
														       type="checkbox" value="{$parentCategory->categoryID}"
														       name="categoryIDs[]"/>
														{$parentCategory->getTitle()|language}
													</label>
												</li>
											{/if}
										{/foreach}
									</ol>
								{/if}
							</li>
						{/if}
					{/foreach}
					{/content}
				</ol>
			{/hascontent}
		{/if}

		{if $errorField == 'categoryIDs'}
			<small class="innerError">
				{if $errorType == 'empty'}{lang}wcf.global.form.error.empty{/lang}{/if}
			</small>
		{/if}
	</section>
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.acp.option.category.general{/lang}</h2>
		<dl>
			<dt></dt>
			<dd>
				<label><input name="subscribe" type="checkbox"
				              value="1"{if $subscribe} checked{/if}
				              data-submit-empty="0"> {lang}de.wbb-elite.news.subscribe{/lang}</label>
				<small>{lang}de.wbb-elite.news.subscribe.description{/lang}</small>
			</dd>
		</dl>
		{if $action == 'edit' && $__wcf->getSession()->getPermission('user.news.newsMarkAsNew')}
			<dl>
				<dt></dt>
				<dd>
					<label><input type="checkbox" id="markAsNew" name="markAsNew" value="1"
					              {if $markAsNew}checked="checked" {/if}/> {lang}de.wbb-elite.news.markAsNew{/lang}
					</label>
				</dd>
			</dl>
		{/if}
		<dl>
			<dt></dt>
			<dd>
				<label><input type="checkbox" id="isHot" name="isHot" value="1"
				              {if $isHot}checked="checked" {/if}/> {lang}de.wbb-elite.news.markIsHot{/lang}
				</label>
			</dd>
		</dl>
		{if $labelGroups|count}
			{foreach from=$labelGroups item=labelGroup}
				{if $labelGroup|count}
					<dl{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset} class="formError"{/if}>
						<dt><label>{$labelGroup->getTitle()}</label></dt>
						<dd>
							<ul class="labelList jsOnly" data-object-id="{@$labelGroup->groupID}">
								<li class="dropdown labelChooser" id="labelGroup{@$labelGroup->groupID}"
								    data-group-id="{@$labelGroup->groupID}"
								    data-force-selection="{if $labelGroup->forceSelection}true{else}false{/if}">
									<div class="dropdownToggle" data-toggle="labelGroup{@$labelGroup->groupID}">
										<span class="badge label">{lang}wcf.label.none{/lang}</span></div>
									<div class="dropdownMenu">
										<ul class="scrollableDropdownMenu">
											{foreach from=$labelGroup item=label}
												<li data-label-id="{@$label->labelID}"><span><span
																class="badge label{if $label->getClassNames()} {@$label->getClassNames()}{/if}">{lang}{$label->label}{/lang}</span></span>
												</li>
											{/foreach}
										</ul>
									</div>
								</li>
							</ul>
							<noscript>
								<select name="labelIDs[{@$labelGroup->groupID}]">
									{foreach from=$labelGroup item=label}
										<option value="{@$label->labelID}">{lang}{$label->label}{/lang}</option>
									{/foreach}
								</select>
							</noscript>
							{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset}
								<small class="innerError">
									{if $errorType[$labelGroup->groupID] == 'missing'}
										{lang}wcf.label.error.missing{/lang}
									{else}
										{lang}wcf.label.error.notValid{/lang}
									{/if}
								</small>
							{/if}
						</dd>
					</dl>
				{/if}
			{/foreach}
		{/if}
	</section>
	{event name='section'}
	{if (DE_WBB_ELITE_NEWS_SOURCE_ENABLE && $__wcf->getSession()->getPermission("user.news.canAddSource")) || $__wcf->getSession()->getPermission("user.news.canUploadPreview") || $__wcf->getSession()->getPermission("user.news.canAddOnlySidebar") || $__wcf->getSession()->getPermission("user.news.canAddBigVersion")}
		<section class="section">
			<h2 class="sectionTitle">{lang}wcf.moderation.report.details{/lang}</h2>
			{if $__wcf->getSession()->getPermission("user.news.canAddOnlySidebar")}
				<dl>
					<dt></dt>
					<dd>
						<label><input id="onlySidebar" name="onlySidebar" type="checkbox"
						              value="1"{if $onlySidebar} checked="checked"{/if} /> {lang}de.wbb-elite.news.onlySidebar{/lang}
						</label>
						<small>{lang}de.wbb-elite.news.onlySidebar.description{/lang}</small>
					</dd>
				</dl>
			{/if}
			{if $__wcf->getSession()->getPermission("user.news.canAddBigVersion")}
				<dl>
					<dt></dt>
					<dd>
						<label><input id="bigVersion" name="bigVersion" type="checkbox"
						              value="1"{if $bigVersion} checked="checked"{/if} /> {lang}de.wbb-elite.news.bigVersion{/lang}
						</label>
						<small>{lang}de.wbb-elite.news.bigVersion.description{/lang}</small>
					</dd>
				</dl>
			{/if}

			{if $__wcf->getSession()->getPermission('mod.news.canEnableNews')}
				<dl>
					<dt></dt>
					<dd>
						<label><input type="checkbox" id="disableNews" name="disableNews" value="1"
						              {if $disableNews}checked="checked" {/if}/> {lang}de.wbb-elite.news.disableNews{/lang}
						</label>
					</dd>
				</dl>
				<dl{if $errorField == 'enableTime'} class="formError"{/if}{if !$disableNews} style="display: none"{/if}>
					<dt><label for="enableTime">{lang}de.wbb-elite.news.enableTime{/lang}</label></dt>
					<dd>
						<input type="datetime" id="enableTime" name="enableTime" value="{$enableTime}" class="medium"/>
						{if $errorField == 'enableTime'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{else}
									{lang}de.wbb-elite.news.enableTime.error.{@$errorType}{/lang}
								{/if}
							</small>
						{/if}
						<small>{lang}de.wbb-elite.news.enableTime.description{/lang}</small>
					</dd>
				</dl>
				<script data-relocate="true">
                    //<![CDATA[
                    $(function () {
                        $('#disableNews').click(function () {
                            $('#enableTime').parents('dl:eq(0)').toggle();
                        });

                        $('#messageContainer').submit(function () {
                            if (!$('#disableNews').is(':checked')) {
                                $('#enableTime').datepicker('destroy');
                                $('input[name=enableTime]').val('');
                            }
                        });
                    });
                    //]]>
				</script>
			{/if}
			{if DE_WBB_ELITE_NEWS_SOURCE_ENABLE && $__wcf->getSession()->getPermission("user.news.canAddSource")}
				<dl{if $errorField == 'sources'} class="formError"{/if}>
					<dt><label for="source">{lang}de.wbb-elite.news.sources.title{/lang}</label></dt>
					<dd class="sortableListContainer" id="sourceContainer">
						<ol{if DE_WBB_ELITE_NEWS_SOURCE_COUNT!= 1} class="sortableList"{/if}></ol>
						{if $errorField == 'sources'}
							<small class="innerError">
								{if $errorType == 'empty'}
									{lang}wcf.global.form.error.empty{/lang}
								{/if}
							</small>
						{/if}
					</dd>
				</dl>
				<script data-relocate="true">
                    require(['WBBElite/News/Source'], function (NewsSource) {
                        new NewsSource('sourceContainer', {if $sources|isset}[{implode from=$sources item=source}{
                            sourceSubject: '{$source[sourceSubject]|encodeJS}',
                            sourceUrl: '{$source[sourceUrl]|encodeJS}'
                        }{/implode} ]{else}[]{/if}, {@DE_WBB_ELITE_NEWS_SOURCE_COUNT});
                    });
				</script>
			{/if}
		</section>
	{/if}
	{include file='captcha'}
	{if $isMultilingual}
		<div class="section tabMenuContainer">
			<nav class="tabMenu">
				<ul>
					{foreach from=$availableContentLanguages item=availableLanguage}
						{assign var='containerID' value='language'|concat:$availableLanguage->languageID}
						<li><a href="{@$__wcf->getAnchor($containerID)}">{$availableLanguage->languageName}</a></li>
					{/foreach}
				</ul>
			</nav>

			{foreach from=$availableContentLanguages item=availableLanguage}
				<div id="language{@$availableLanguage->languageID}" class="tabMenuContent">
					<div class="section">
						{if $__wcf->getSession()->getPermission("user.news.canUploadPreview")}
							<dl{if $errorField == 'image'|concat:$availableLanguage->languageID} class="formError"{/if}>
								<dt>
									<label for="image{@$availableLanguage->languageID}">{lang}de.wbb-elite.news.preview.information{/lang}</label>
								</dt>
								<dd>
									<div class="previewImage">
										{if $previewImageID[$availableLanguage->languageID]|isset && $previewImageID[$availableLanguage->languageID]}
											<img src="{link controller="NewsImage" id=$previewImageID[$availableLanguage->languageID] application="news"}{/link}"
											     alt="" id="newsImage{$availableLanguage->languageID}">
											<span class="button jsDeleteButton"
											      data-object-id="{$previewImageID[$availableLanguage->languageID]}"
											      data-confirm-message="{lang}de.wbb-elite.news.previewImage.delete.sure{/lang}">{lang}wcf.global.button.delete{/lang}</span>
										{else}
											<img src="{@$__wcf->getPath()}images/stylePreview.png"
											     alt="" id="newsImage{$availableLanguage->languageID}">
										{/if}
									</div>
									<div id="previewImage{$availableLanguage->languageID}"
									     class="previewImageContainer">
										{if $previewImageID[$availableLanguage->languageID]|isset && $previewImageID[$availableLanguage->languageID]}
											<input class="imagePreviewID" type="hidden"
											       value="{$previewImageID[$availableLanguage->languageID]}"
											       name="imageID[{$availableLanguage->languageID}]">
										{/if}
									</div>
									{if $errorField == 'image'|concat:$availableLanguage->languageID}
										<small class="innerError">{lang}wcf.acp.article.image.error.{@$errorType}{/lang}</small>
									{/if}
								</dd>
							</dl>
							<script data-relocate="true">
                                require(['WBBElite/News/Upload'], function (NewsImageUpload) {
                                    new NewsImageUpload({if $action == "edit"}{$newsID}{else}0{/if},{@$availableLanguage->languageID}, 'previewImage{@$availableLanguage->languageID}', 'newsImage{@$availableLanguage->languageID}', '{@$__wcf->getPath()}images/stylePreview.png', {if $__wcf->getSession()->getPermission("user.news.canUseDefaultImage")}true{else}false{/if});
                                });
							</script>
						{/if}

						<dl{if $errorField == 'subject'|concat:$availableLanguage->languageID} class="formError"{/if}>
							<dt>
								<label for="subject{@$availableLanguage->languageID}">{lang}wcf.global.title{/lang}</label>
							</dt>
							<dd>
								<input type="text" id="subject{@$availableLanguage->languageID}"
								       name="subject[{@$availableLanguage->languageID}]"
								       value="{if !$subject[$availableLanguage->languageID]|empty}{$subject[$availableLanguage->languageID]}{/if}"
								       class="long" maxlength="255">
								{if $errorField == 'subject'|concat:$availableLanguage->languageID}
									<small class="innerError">
										{if $errorType == 'empty'}
											{lang}wcf.global.form.error.empty{/lang}
										{else}
											{lang}wcf.acp.article.subject.error.{@$errorType}{/lang}
										{/if}
									</small>
								{/if}
							</dd>
						</dl>

						{if MODULE_TAGGING}
							<dl class="jsOnly">
								<dt>
									<label for="tag{@$availableLanguage->languageID}">{lang}wcf.tagging.tags{/lang}</label>
								</dt>
								<dd>
									<input id="tag{@$availableLanguage->languageID}" type="text" value=""
									       class="long">
									<small>{lang}wcf.tagging.tags.description{/lang}</small>
								</dd>
							</dl>
							<script data-relocate="true">
                                require(['WoltLabSuite/Core/Ui/ItemList'], function (UiItemList) {
                                    UiItemList.init(
                                        'tag{@$availableLanguage->languageID}',
                                        [{if $tags[$availableLanguage->languageID]|isset && !$tags[$availableLanguage->languageID]|empty}{implode from=$tags[$availableLanguage->languageID] item=tag}'{$tag|encodeJS}'{/implode}{/if}],
                                        {
                                            ajax: {
                                                className: 'wcf\\data\\tag\\TagAction'
                                            },
                                            maxLength: {@TAGGING_MAX_TAG_LENGTH},
                                            submitFieldName: 'tags[{@$availableLanguage->languageID}][]'
                                        }
                                    );
                                });
							</script>
						{/if}

						<dl{if $errorField == 'teaser'|concat:$availableLanguage->languageID} class="formError"{/if}>
							<dt>
								<label for="teaser{@$availableLanguage->languageID}">{lang}wcf.acp.article.teaser{/lang}</label>
							</dt>
							<dd>
                            <textarea name="teaser[{@$availableLanguage->languageID}]"
                                      id="teaser{@$availableLanguage->languageID}"
                                      class="wysiwygTextarea"
                                      data-autosave="de.wbb-elite.news.news.teaser{if $action == "add"}Add-{@$__wcf->getUser()->userID}{else}Edit-{@$news->newsID}-{@$availableLanguage->languageID}{/if}"
                                      rows="5">{if !$teaser[$availableLanguage->languageID]|empty}{$teaser[$availableLanguage->languageID]}{/if}</textarea>
								{include file='wysiwyg' wysiwygSelector='teaser'|concat:$availableLanguage->languageID}
								{if $errorField == 'teaser'|concat:$availableLanguage->languageID}
									<small class="innerError">
										{if $errorType == 'empty'}
											{lang}wcf.global.form.error.empty{/lang}
										{elseif $errorType == 'tooLong'}
											{lang}wcf.message.error.tooLong{/lang}
										{elseif $errorType == 'censoredWordsFound'}
											{lang}wcf.message.error.censoredWordsFound{/lang}
										{elseif $errorType == 'disallowedBBCodes'}
											{lang}wcf.message.error.disallowedBBCodes{/lang}
										{elseif $errorType == 'multilingual'}
											{lang}wcf.global.form.error.multilingual{/lang}
										{else}
											{lang}de.wbb-elite.news.error.{@$errorType}{/lang}
										{/if}
									</small>
								{/if}
								<small>{lang}de.wbb-elite.news.teaser.description{/lang}</small>
							</dd>
						</dl>

						<dl{if $errorField == 'text'|concat:$availableLanguage->languageID} class="formError"{/if}>
							<dt>
								<label for="text{@$availableLanguage->languageID}">{lang}wcf.acp.article.content{/lang}</label>
							</dt>
							<dd>
                            <textarea name="text[{@$availableLanguage->languageID}]"
                                      id="text{@$availableLanguage->languageID}" class="wysiwygTextarea"
                                      data-autosave="de.wbb-elite.news.news{if $action == "add"}Add-{@$__wcf->getUser()->userID}{else}Edit-{@$news->newsID}-{@$availableLanguage->languageID}{/if}">{if !$text[$availableLanguage->languageID]|empty}{$text[$availableLanguage->languageID]}{/if}</textarea>
								{include file='wysiwyg' wysiwygSelector='text'|concat:$availableLanguage->languageID}
								{include file='messageFormTabs' tmpHash=$tmpHashArray[$availableLanguage->languageID] attachmentHandler=$attachmentHandlerArray[$availableLanguage->languageID] wysiwygContainerID='text'|concat:$availableLanguage->languageID}
								{if $errorField == 'text'|concat:$availableLanguage->languageID}
									<small class="innerError">
										{if $errorType == 'empty'}
											{lang}wcf.global.form.error.empty{/lang}
										{else}
											{lang}wcf.acp.article.content.error.{@$errorType}{/lang}
										{/if}
									</small>
								{/if}
							</dd>
						</dl>
					</div>
				</div>
			{/foreach}
		</div>
	{else}
		<div class="section">
			{if $__wcf->getSession()->getPermission("user.news.canUploadPreview")}
				<dl{if $errorField == 'image'} class="formError"{/if}>
					<dt>
						<label for="image">{lang}de.wbb-elite.news.preview.information{/lang}</label>
					</dt>
					<dd>
						<div class="previewImage">
							{if $previewImageID|isset && $previewImageID}
								<img src="{link controller="NewsImage" id=$previewImageID application="news"}{/link}"
								     alt="" id="newsImage">
								<span class="button jsDeleteButton"
								      data-object-id="{$previewImageID}"
								      data-confirm-message="{lang}de.wbb-elite.news.previewImage.delete.sure{/lang}">{lang}wcf.global.button.delete{/lang}</span>
							{else}
								<img src="{@$__wcf->getPath()}images/stylePreview.png"
								     alt="" id="newsImage">
							{/if}
						</div>
						<div id="previewImage" class="previewImageContainer">
							{if $previewImageID|isset && $previewImageID}
								<input class="imagePreviewID" type="hidden"
								       value="{$previewImageID}"
								       name="imageID">
							{/if}
						</div>
						{if $errorField == 'image'}
							<small class="innerError">{lang}wcf.acp.article.image.error.{@$errorType}{/lang}</small>
						{/if}
					</dd>
				</dl>
				<script data-relocate="true">
                    require(['WBBElite/News/Upload'], function (NewsImageUpload) {
                        new NewsImageUpload({if $action == "edit"}{$newsID}{else}0{/if}, 0, 'previewImage', 'newsImage', '{@$__wcf->getPath()}images/stylePreview.png', {if $__wcf->getSession()->getPermission("user.news.canUseDefaultImage")}true{else}false{/if});
                    });
				</script>
			{/if}

			<dl{if $errorField == 'subject'} class="formError"{/if}>
				<dt><label for="subject">{lang}wcf.global.title{/lang}</label>
				</dt>
				<dd>
					<input type="text" id="subject"
					       name="subject"
					       value="{if !$subject|empty}{$subject}{/if}"
					       class="long" maxlength="255">
					{if $errorField == 'subject'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wcf.acp.article.subject.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>

			{if MODULE_TAGGING}
				<dl class="jsOnly">
					<dt>
						<label for="tag">{lang}wcf.tagging.tags{/lang}</label>
					</dt>
					<dd>
						<input id="tag" type="text" value=""
						       class="long">
						<small>{lang}wcf.tagging.tags.description{/lang}</small>
					</dd>
				</dl>
				<script data-relocate="true">
                    require(['WoltLabSuite/Core/Ui/ItemList'], function (UiItemList) {
                        UiItemList.init(
                            'tag',
                            [{if $tags && !$tags|empty}{implode from=$tags item=tag}'{$tag|encodeJS}'{/implode}{/if}],
                            {
                                ajax: {
                                    className: 'wcf\\data\\tag\\TagAction'
                                },
                                maxLength: {@TAGGING_MAX_TAG_LENGTH},
                                submitFieldName: 'tags[]'
                            }
                        );
                    });
				</script>
			{/if}

			<dl{if $errorField == 'teaser'} class="formError"{/if}>
				<dt>
					<label for="teaser">{lang}wcf.acp.article.teaser{/lang}</label>
				</dt>
				<dd>
                            <textarea name="teaser"
                                      class="wysiwygTextarea"
                                      id="teaser"
                                      data-autosave="de.wbb-elite.news.news.teaser{if $action == "add"}Add-{@$__wcf->getUser()->userID}{else}Edit-{@$news->newsID}-{/if}"
                                      rows="5">{if !$teaser|empty}{$teaser}{/if}</textarea>
					{include file='wysiwyg' wysiwygSelector='teaser'}
					{if $errorField == 'teaser'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{elseif $errorType == 'tooLong'}
								{lang}wcf.message.error.tooLong{/lang}
							{elseif $errorType == 'censoredWordsFound'}
								{lang}wcf.message.error.censoredWordsFound{/lang}
							{elseif $errorType == 'disallowedBBCodes'}
								{lang}wcf.message.error.disallowedBBCodes{/lang}
							{elseif $errorType == 'multilingual'}
								{lang}wcf.global.form.error.multilingual{/lang}
							{else}
								{lang}de.wbb-elite.news.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}de.wbb-elite.news.teaser.description{/lang}</small>
				</dd>
			</dl>

			<dl{if $errorField == 'text'} class="formError"{/if}>
				<dt>
					<label for="text">{lang}wcf.acp.article.content{/lang}</label>
				</dt>
				<dd>
                            <textarea name="text"
                                      id="text" class="wysiwygTextarea"
                                      data-autosave="de.wbb-elite.news.news{if $action == "add"}Add-{@$__wcf->getUser()->userID}{else}Edit-{@$news->newsID}-{/if}">{if !$text|empty}{$text}{/if}</textarea>
					{include file='wysiwyg' wysiwygSelector='text'}
					{include file='messageFormTabs' tmpHash=$tmpHash attachmentHandler=$attachmentHandler wysiwygContainerID='text'}
					{if $errorField == 'text'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wcf.acp.article.content.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
		</div>
	{/if}
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s"/>
		{if $action == "add"}<input type="hidden" name="isMultilingual" value="{$isMultilingual}">{/if}
		{if !$newsID|isset}{assign var="newsID" value=0}{/if}
		{@SECURITY_TOKEN_INPUT_TAG}
		{if $isMultilingual}
			{foreach from=$availableContentLanguages item=availableLanguage}
				{include file='messageFormPreviewButton' previewButtonID="buttonMessagePreview"|concat:$availableLanguage->languageID previewMessageFieldID="text"|concat:$availableLanguage->languageID previewMessageObjectType='de.wbb-elite.news.message' previewMessageObjectID=$newsID}
				<input type="hidden" name="tmpHash[{$availableLanguage->languageID}]"
				       value="{$tmpHashArray[$availableLanguage->languageID]}">
			{/foreach}
		{else}
			{include file='messageFormPreviewButton' previewMessageObjectType='de.wbb-elite.news.message' previewMessageObjectID=$newsID}
			<input type="hidden" name="tmpHash"
			       value="{$tmpHash}">
		{/if}
	</div>
</form>

<script data-relocate="true">
	{if $isMultilingual}
    elBySelAll('.tabMenuContainer .tabMenu > ul > li', null, function (element) {
        element.addEventListener(WCF_CLICK_EVENT, function () {
            elBySelAll('.formSubmit > button.jsOnly', null, function (button) {
                elHide(button);
            });
            elShow(elById('buttonMessagePreview' + elData(element, "name").replace("language", "")));
        });
    });
	{/if}
	{if !$labelGroups|empty}
    require(['WBBElite/News/Label/Chooser'], function (LabelChooser) {
        new LabelChooser({@DE_WBB_ELITE_NEWS_SHOW_CATEGORY_LIST_NEWS_ADD}, { {implode from=$labelGroupsToCategories key=__labelCategoryID item=labelGroupIDs} {@$__labelCategoryID}:
        [ {implode from=$labelGroupIDs item=labelGroupID}{@$labelGroupID}{/implode} ] {/implode} },
        { {implode from=$labelIDs key=groupID item=labelID}{@$groupID}: {@$labelID}{/implode} }
    ,
        '#messageContainer'
    )
        ;
    });
	{/if}
    $(function () {
        $('.tabMenuContainer .tabMenu > ul > li.active').trigger('click');
        new WCF.Action.Delete('news\\data\\news\\image\\NewsImageAction', '#previewImage dl ul > li');
        new WCF.Category.NestedList();
    });
</script>
{include file='footer'}