<?phpnamespace news\data\news;use wcf\data\DatabaseObjectList;use wcf\system\WCF;use wcf\util\StringUtil;/** * Represents a list of News. * * @author    Olaf Braun * @copyright 2013-2017 Olaf Braun - Software Development * @license   WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html> * @package   de.wbb-elite.news * @category  News-System * * @method    News        current() * @method    News[]        getObjects() * @method    News|null    search($objectID) * @property    News[] $objects */class NewsList extends DatabaseObjectList {	/**	 * @inheritdoc	 */	public $className = News::class;		/**	 * @inheritdoc	 */	public function countObjects() {		$sql = "SELECT	COUNT(DISTINCT(news.newsID)) AS count			FROM	" . $this->getDatabaseTableName() . " " . $this->getDatabaseTableAlias() . "			" . $this->sqlConditionJoins . "			" . $this->getConditionBuilder();		$statement = WCF::getDB()->prepareStatement($sql);		$statement->execute($this->getConditionBuilder()->getParameters());		$row = $statement->fetchArray();				return $row['count'];	}		/**	 * @inheritdoc	 */	public function readObjectIDs() {		$this->objectIDs = [];		$sql = "SELECT	DISTINCT " . $this->getDatabaseTableAlias() . "." . $this->getDatabaseTableIndexName() . " AS objectID, " . $this->getDatabaseTableAlias() . ".*			FROM	" . $this->getDatabaseTableName() . " " . $this->getDatabaseTableAlias() . "				" . $this->sqlConditionJoins . "				" . $this->getConditionBuilder() . "				" . (!empty($this->sqlOrderBy) ? "ORDER BY " . $this->sqlOrderBy : '');				$statement = WCF::getDB()->prepareStatement($sql, $this->sqlLimit, $this->sqlOffset);		$statement->execute($this->getConditionBuilder()->getParameters());				while ($row = $statement->fetchArray()) {			$this->objectIDs[] = $row['objectID'];		}	}		/**	 * @inheritdoc	 */	public function readObjects() {		if (StringUtil::startsWith($this->sqlSelects, ",")) {			$this->sqlSelects = mb_substr($this->sqlSelects, 1, strlen($this->sqlSelects) - 1);		} elseif (StringUtil::startsWith($this->sqlSelects, " ,")) {			$this->sqlSelects = mb_substr($this->sqlSelects, 2, strlen($this->sqlSelects) - 2);		}		if ($this->objectIDs !== null) {			if (empty($this->objectIDs)) {				return;			}			$sql = "SELECT DISTINCT(news.newsID), " . (!empty($this->sqlSelects) ? $this->sqlSelects . ($this->useQualifiedShorthand ? ',' : '') : '') . "						" . ($this->useQualifiedShorthand ? $this->getDatabaseTableAlias() . '.*' : '') . "				FROM	" . $this->getDatabaseTableName() . " " . $this->getDatabaseTableAlias() . "					" . $this->sqlJoins . "				WHERE	" . $this->getDatabaseTableAlias() . "." . $this->getDatabaseTableIndexName() . " IN (?" . str_repeat(',?', count($this->objectIDs) - 1) . ")					" . (!empty($this->sqlOrderBy) ? "ORDER BY " . $this->sqlOrderBy : '');						$statement = WCF::getDB()->prepareStatement($sql);			$statement->execute($this->objectIDs);			$this->objects = $statement->fetchObjects(($this->objectClassName ?: $this->className));					} else {			$sql = "SELECT DISTINCT(news.newsID), " . (!empty($this->sqlSelects) ? $this->sqlSelects . ($this->useQualifiedShorthand ? ',' : '') : '') . "					" . ($this->useQualifiedShorthand ? $this->getDatabaseTableAlias() . '.*' : '') . "				FROM	" . $this->getDatabaseTableName() . " " . $this->getDatabaseTableAlias() . "					" . $this->sqlJoins . "					" . $this->getConditionBuilder() . "					" . (!empty($this->sqlOrderBy) ? "ORDER BY " . $this->sqlOrderBy : '');			$statement = WCF::getDB()->prepareStatement($sql, $this->sqlLimit, $this->sqlOffset);			$statement->execute($this->getConditionBuilder()->getParameters());			$this->objects = $statement->fetchObjects(($this->objectClassName ?: $this->className));		}				// decorate objects		if (!empty($this->decoratorClassName)) {			foreach ($this->objects as &$object) {				$object = new $this->decoratorClassName($object);			}			unset($object);		}				// use table index as array index		$objects = [];		foreach ($this->objects as $object) {			$objectID = $object->getObjectID();			$objects[$objectID] = $object;						$this->indexToObject[] = $objectID;		}		$this->objectIDs = $this->indexToObject;		$this->objects = $objects;	}}