<?php
namespace wsif\acp\form;

use wsif\data\category\Category;
use wsif\data\category\CategoryNodeTree;
use wcf\form\AbstractForm;
use wcf\system\acl\ACLHandler;
use wcf\system\language\I18nHandler;
use wcf\system\exception\UserInputException;
use wcf\system\WCF;


class CategoryRightsCopyForm extends AbstractForm  {
	/**
	 * @see	\wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'wsif.acp.menu.category.rights.copy';
	
	/**
	 * @see	\wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededPermissions = array('admin.wsif.canManageCategoryRightsCopy');
	
	public $category = '';
	
	/**
	 * Target
	 */
	private $targetcategorys = array();

	/**
	 * object type id
	 * @var    integer
	 */
	public $objectTypeID = 0;
	
	/**
	 * @see	\wcf\page\IPage::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['sourcecategory'])) $this->sourcecategory = intval($_REQUEST['sourcecategory']);
		if (isset($_REQUEST['targetcategorys'])) $this->targetcategorys = (empty($_REQUEST['targetcategorys'])) ? array() : $_REQUEST['targetcategorys'];

		$this->objectTypeID = ACLHandler::getInstance()->getObjectTypeID('com.wcfsolutions.wsif.category');
	}
	
	/**
	 * @see    \wcf\form\IForm::validate()
	 */
	public function validate() {
		parent::validate();
		
		$this->validateSourceGroupID();
		
		$this->validateTargetGroupIDs();
	}
	
	/**
	 * Validate if source is empty nor
	 */
	protected function validateSourceGroupID() {		
		if ($this->sourcecategory == null) {
			throw new UserInputException('sourcecategory', 'noSelection');
		}
	}
	
	/**
	 * Validate if target is empty nor
	 */
	protected function validateTargetGroupIDs() {
		if (count($this->targetcategorys) == 0) {
			throw new UserInputException('targetcategorys', 'noSelection');
		}
	}
	
	/**
	 * @see	\wcf\form\IForm::save()
	 */
	public function save() {
		parent::save();

		// load source permissions
		$source = ACLHandler::getInstance()->getPermissions($this->objectTypeID, array($this->sourcecategory));

		// simulate post
		$_POST['aclValues'] = array();
		$_POST['aclValues']['group'] = array();
		$_POST['aclValues']['user'] = array();

		if(count($source['group']) > 0) $_POST['aclValues']['group'] = $source['group'][$this->sourcecategory];
		if(count($source['user']) > 0) $_POST['aclValues']['user'] = $source['user'][$this->sourcecategory];

		// save ACL each target board
		foreach($this->targetcategorys AS $target) {
			ACLHandler::getInstance()->save($target, $this->objectTypeID);
		}

		ACLHandler::getInstance()->disableAssignVariables();
		$this->saved();

		// show success
		WCF::getTPL()->assign(array(
			'success' => true
		));	
	}
	
	/**
	 * @see	\wcf\page\IPage::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();

		I18nHandler::getInstance()->assignVariables();
		
		WCF::getTPL()->assign(array(
			'category' => $this->category,
		));
	}
}
