{include file='header' pageTitle='wbb.acp.threadsAndPosts.post.rating.list'}

<script data-relocate="true">
    //<![CDATA[
    $(function () {
        new WCF.Action.Delete('wbb\\data\\post\\rating\\PostRatingAction', '.jsTemplateRow');
        new WCF.Action.Toggle('wbb\\data\\post\\rating\\PostRatingAction', '.jsTemplateRow');

        var options = { };
        {if $pages > 1}
        options.refreshPage = true;
        {if $pages == $pageNo}
        options.updatePageNumber = -1;
        {/if}
        {else}
        options.emptyMessage = '{lang}wcf.global.noItems{/lang}';
        {/if}

        new WCF.Table.EmptyTableHandler($('#userIconTableContainer'), 'jsTemplateRow', options);
    });
    //]]>
</script>

<header class="boxHeadline">
    <h1>{lang}wbb.acp.threadsAndPosts.post.rating.list{/lang}</h1>
</header>

<div class="contentNavigation">
    {pages print=true assign=pagesLinks controller="PostRatingList" link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}

    <nav>
        <ul>
            {event name='contentNavigationButtonsTopBefore'}

            <li><a href="{link controller='PostRatingAdd'}{/link}" class="button"><span
                            class="icon icon16 icon-plus"></span>
                    <span>{lang}wbb.acp.threadsAndPosts.post.rating.button.add{/lang}</span></a></li>

            {event name='contentNavigationButtonsTopAfter'}
        </ul>
    </nav>
</div>

{if $objects|count}
    <div id="userIconTableContainer" class="tabularBox tabularBoxTitle marginTop">
        <header>
            <h2>{lang}wbb.acp.threadsAndPosts.post.rating.button.add{/lang} <span
                        class="badge badgeInverse">{#$items}</span></h2>
        </header>

        <table class="table">
            <thead>
            <tr>
                <th class="columnID columnIconObjectID {if $sortField == 'iconID'}active {@$sortOrder}{/if}"
                    colspan="2"><a
                            href="{link controller='PostRatingList'}pageNo={@$pageNo}&sortField=iconID&sortOrder={if $sortField == 'iconID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wbb.acp.threadsAndPosts.post.rating.list.columnObjectID{/lang}</a>
                </th>
                <th class="columnTitle columnIconSidebarIcon">{lang}wbb.acp.threadsAndPosts.post.rating.list.columnSidebarIcon{/lang}</th>
                <th class="columnText columnIconTitle {if $sortField == 'title'} active {@$sortOrder}{/if}"><a
                            href="{link controller='PostRatingList'}pageNo={@$pageNo}&sortField=title&sortOrder={if $sortField == 'title' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wbb.acp.threadsAndPosts.post.rating.list.columnObjectTitle{/lang}</a>
                </th>

                {event name='columnHeads'}
            </tr>
            </thead>

            <tbody>
            {foreach from=$objects item=object}
                <tr class="jsTemplateRow">
                    <td class="columnIcon">
                        <a href="{link controller='PostRatingEdit' object=$object id=$object->ratingID}{/link}"
                           title="{lang}wbb.acp.threadsAndPosts.post.rating.button.edit{/lang}" class="jsTooltip"><span
                                    class="icon icon16 icon-pencil"></span></a>
                        <span class="icon icon16 icon-remove jsDeleteButton jsTooltip pointer"
                              title="{lang}wbb.acp.threadsAndPosts.post.rating.button.delete{/lang}"
                              data-object-id="{@$object->ratingID}"></span>
                        <span class="icon icon16 icon-check{if $object->isDisabled}-empty{/if} jsToggleButton jsTooltip pointer"
                              title="{lang}wbb.acp.threadsAndPosts.post.rating.button.{if !$object->isDisabled}disable{else}enable{/if}{/lang}"
                              data-object-id="{@$object->ratingID}"
                              data-disable-message="{lang}wbb.acp.threadsAndPosts.post.rating.button.disable{/lang}"
                              data-enable-message="{lang}wbb.acp.threadsAndPosts.post.rating.button.enable{/lang}"></span>

                        {event name='rowButtons'}
                    </td>
                    <td class="columnID columnIconObjectID">{@$object->ratingID}</td>
                    <td class="columnTitle columnIconSidebarIcon"><img src="{@$object->getPreviewImage()}"
                                                                       style="width: 16px; height: 16px" alt=""></td>
                    <td class="columnText columnIconTitle">{@$object->getTitle()}</td>

                    {event name='columns'}
                </tr>
            {/foreach}
            </tbody>
        </table>
    </div>
    <div class="contentNavigation">
        {@$pagesLinks}

        <nav>
            <ul>
                {event name='contentNavigationButtonsBottomBefore'}

                <li><a href="{link controller='PostRatingAdd'}{/link}" class="button"><span
                                class="icon icon16 icon-plus"></span>
                        <span>{lang}wbb.acp.threadsAndPosts.post.rating.button.add{/lang}</span></a></li>

                {event name='contentNavigationButtonsBottomAfter'}
            </ul>
        </nav>
    </div>
{else}
    <p class="info">{lang}wcf.global.noItems{/lang}</p>
{/if}

{include file='footer'}