<?php
namespace wbb\acp\page;
use wcf\page\SortablePage;

/**
 * Lists available post rating icons.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingListPage extends SortablePage {
  /**
   * @see \wcf\page\AbstractPage::$activeMenuItem
   */
  public $activeMenuItem = 'wbb.acp.menu.link.threadsAndPosts.postRatingList';
  
  /**
   * @see \wcf\page\SortablePage::$defaultSortField
   */
  public $defaultSortField = 'ratingID';
  
  /**
   * @see  wcf\page\MultipleLinkPage::$objectListClassName
   */
  public $objectListClassName = 'wbb\data\post\rating\PostRatingList';
  
  /**
   * @see \wcf\page\SortablePage::$validSortFields
   */
  public $validSortFields = array('ratingID', 'title');
}