<?php
namespace wbb\acp\form;

use wbb\data\post\rating\PostRatingAction;
use wbb\data\post\rating\PostRatingEditor;
use wcf\data\package\PackageCache;
use wcf\form\AbstractForm;
use wcf\system\exception\UserInputException;
use wcf\system\language\I18nHandler;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Shows the post rating add form.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingAddForm extends AbstractForm{
	/**
	 * @see \wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'wbb.acp.menu.link.threadsAndPosts.postRatingAdd';

	/**
	 * @see \wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededPermissions = array('admin.content.canManagePostRating');

	/**
	 * title
	 *
	 * @var string
	 */
	public $title = '';

	/**
	 * description
	 *
	 * @var string
	 */
	public $description = '';

	/**
	 * is first post
	 *
	 * @var boolean
	 */
	public $isFirstPost = 0;

	/**
	 * amount
	 *
	 * @var integer
	 */
	public $amount = '';

	/**
	 * temporary image hash
	 *
	 * @var  string
	 */
	public $tmpHash = '';

	/**
	 * temporary image hash
	 *
	 * @var  string
	 */
	public $fileName = '';

	/**
	 * temporary image hash
	 *
	 * @var  string
	 */
	public $extension = '';


	/**
	 * @see \wcf\page\IPage::assignVariables()
	 */
	public function assignVariables(){
		parent::assignVariables();

		I18nHandler::getInstance()->assignVariables();

		WCF::getTPL()->assign(array(
			'action'      => 'add',
			'title'       => $this->title,
			'description' => $this->description,
			'isFirstPost' => $this->isFirstPost,
			'amount'      => $this->amount,
			'extension'   => $this->extension,
			'fileName'    => $this->fileName,
			'tmpHash'     => $this->tmpHash,
		));
	}

	/**
	 * @see \wcf\form\IForm::readFormParameters()
	 */
	public function readFormParameters(){
		parent::readFormParameters();

		// read i18n values
		I18nHandler::getInstance()->readValues();

		// handle i18n plain input
		if(I18nHandler::getInstance()->isPlainValue('description')) $this->description = I18nHandler::getInstance()->getValue('description');

		if(!empty($_POST['title'])) $this->title = StringUtil::trim($_POST['title']);
		if(!empty($_POST['extension'])) $this->extension = StringUtil::trim($_POST['extension']);
		if(!empty($_POST['fileName'])) $this->fileName = StringUtil::trim($_POST['fileName']);
		if(!empty($_POST['isFirstPost'])) $this->isFirstPost = (bool)$_POST['isFirstPost'];
		if(!empty($_POST['amount'])) $this->amount = intval($_POST['amount']);
	}

	/**
	 * @see \wcf\page\IPage::readParameters()
	 */
	public function readParameters(){
		parent::readParameters();

		I18nHandler::getInstance()->register('description');

		if(isset($_REQUEST['tmpHash'])){
			$this->tmpHash = StringUtil::trim($_REQUEST['tmpHash']);
		}
		if(empty($this->tmpHash)){
			$this->tmpHash = StringUtil::getRandomID();
		}
	}

	/**
	 * @see \wcf\form\IForm::save()
	 */
	public function save(){
		parent::save();


		// save rating
		$this->objectAction = new PostRatingAction(array(), 'create', array(
			'data'      => array_merge($this->additionalFields, array(
				'title'       => $this->title,
				'description' => $this->description,
				'isFirstPost' => $this->isFirstPost ? 1 : 0,
				'amount'      => $this->amount
			)),
			'tmpHash'   => $this->tmpHash,
			'fileName'  => $this->fileName,
			'extension' => $this->extension
		));
		$returnValues = $this->objectAction->executeAction();
		$postRating = $returnValues['returnValues'];

		// save description
		if(!I18nHandler::getInstance()->isPlainValue('description')){
			I18nHandler::getInstance()->save('description', 'wbb.post.rating'.$postRating->ratingID, 'wbb.post', PackageCache::getInstance()->getPackageID('com.woltlab.wbb'));

			// update name
			$postRatingEditor = new PostRatingEditor($postRating);
			$postRatingEditor->update(array(
				'description' => 'wbb.post.rating'.$postRating->ratingID
			));
		}

		// call saved event
		$this->saved();

		// reset values
		$this->image = $this->description = $this->extension = $this->title = $this->fileName = '';
		$this->isFirstPost = $this->amount = 0;

		I18nHandler::getInstance()->reset();

		// show success
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}

	/**
	 * @see \wcf\form\IForm::validate()
	 */
	public function validate(){
		parent::validate();

		// validate description
		if(!I18nHandler::getInstance()->validateValue('description', false, true)){
			throw new UserInputException('description');
		}
	}
}