<?php
namespace wbb\data\post\rating;

use wcf\data\DatabaseObjectDecorator;

/**
 * Represents a viewable post rating icon.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class ViewablePostRating extends DatabaseObjectDecorator{
	/**
	 * @see \wcf\data\DatabaseObjectDecorator::$baseClass
	 */
	protected static $baseClass = 'wbb\data\post\rating\PostRating';


	/**
	 * Gets a specific post rating id decorated as viewable post rating.
	 *
	 * @param integer $postRatingID
	 *
	 * @return \wbb\data\post\rating\ViewablePostRatingList
	 */
	public static function getViewablePostRating($postRatingID){
		$list = new ViewablePostRatingList();
		$list->getConditionBuilder()->add('post_rating.ratingID = ?', array(
			$postRatingID
		));
		$list->readObjects();
		$objects = $list->getObjects();
		if(isset($objects[$postRatingID])) return $objects[$postRatingID];

		return null;
	}
}