<?php
namespace wbb\data\post\rating;

use wbb\system\cache\builder\PostRatingCacheBuilder;
use wcf\system\SingletonFactory;
use wcf\system\WCF;

/**
 * Manages the post rating icon cache.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingCache extends SingletonFactory{
	/**
	 * list of cached post rating icons
	 *
	 * @var array<\wbb\data\post\rating\PostRating>
	 */
	protected $postRatingsCached = array();


	/**
	 * Returns a list of all post rating icons.
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatings(){
		return $this->postRatingsCached['entry'];
	}

	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $userID
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatingsByUserID($userID){
		return isset($this->postRatingsCached['user'][$userID]) ? $this->postRatingsCached['user'][$userID] : null;
	}

	public function getPostRatingCountByUserID($userID, $ratingID){
		$sql = 'SELECT COUNT(*) as counter FROM wbb'.WCF_N.'_post_rating_to_post WHERE ratingID = ? AND posterID = ?';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array($ratingID, $userID));
		$count = $statement->fetchArray()["counter"];

		return $count;
	}

	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $postID
	 *
	 * @return integer
	 */
	public function getPostRatingsCount($postID){
		return isset($this->postRatingsCached['count'][$postID]) ? $this->postRatingsCached['count'][$postID] : 0;
	}
	/**
	 * Returns whether the post has ratings
	 *
	 * @param integer $postID
	 *	 *
	 * @return integer
	 */

	public function postHasRatings($postID){
		foreach($this->getPostRatings() as $postRating){
            $count = $this->getPostRatingsRatingCount($postID, $postRating->ratingID);

            if($count > 0){
                return true;
            }
        }
        
        return false;
	}

	/**
	 * Returns the rating account by the postID and ratingID
	 *
	 * @param integer $postID
	 *	 *
	 * @param integer $ratingID
	 *	 *
	 * @return integer
	 */

	public function getPostRatingsRatingCount($postID, $ratingID){
		if(isset($this->postRatingsCached['postToEntry'][$postID])  && isset($this->postRatingsCached['postToEntry'][$postID][$ratingID]) ){
			return $this->postRatingsCached['postToEntry'][$postID][$ratingID];
		}
		return 0;
	}
	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $postID
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatingsByPostID($postID){
		return isset($this->postRatingsCached['post'][$postID]) ? $this->postRatingsCached['post'][$postID] : null;
	}

	/**
	 * @see \wcf\system\SingletonFactory::init()
	 */
	protected function init(){
		$this->postRatingsCached = PostRatingCacheBuilder::getInstance()->getData();
	}
}