<?php
namespace wbb\data\post\rating;

use wbb\system\cache\builder\PostRatingCacheBuilder;
use wcf\data\DatabaseObjectEditor;
use wcf\data\IEditableCachedObject;
use wcf\system\image\ImageHandler;

/**
 * Provides functions to edit post ratings.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingEditor extends DatabaseObjectEditor implements IEditableCachedObject{
	/**
	 * @see \wcf\data\DatabaseObjectDecorator::$baseClass
	 */
	protected static $baseClass = 'wbb\data\post\rating\PostRating';


	/**
	 * @see \wcf\data\IEditableObject::create()
	 */
	public static function create(array $parameters = array()){
		// save post rating
		$postRating = parent::create($parameters);

		// scale preview post rating image
		if(!empty($parameters['image'])){
			self::scalePreviewImage(WCF_DIR.$parameters['image']);
		}

		return $postRating;
	}

	/**
	 * @see \wcf\data\IEditableObject::delete()
	 */
	public function delete(){
		parent::delete();

		// delete preview image
		if($this->image){
			@unlink(WCF_DIR.'images/'.$this->image);
		}
	}

	/**
	 * @see \wcf\data\IEditableCachedObject::resetCache()
	 */
	public static function resetCache(){
		PostRatingCacheBuilder::getInstance()->reset();
	}

	/**
	 * Scales the post rating preview image.
	 *
	 * @param string $filename
	 */
	public static function scalePreviewImage($filename){
		$adapter = ImageHandler::getInstance()->getAdapter();
		$adapter->loadFile(WCF_DIR.'images/post/rating/'.$filename);
		$thumbnail = $adapter->createThumbnail(PostRating::PREVIEW_IMAGE_MAX_HEIGHT, PostRating::PREVIEW_IMAGE_MAX_WIDTH);
		$adapter->writeImage($thumbnail, WCF_DIR.'images/post/rating/'.$filename);
	}

	/**
	 * @see \wcf\data\IEditableObject::update()
	 */
	public function update(array $parameters = array()){
		// update post rating data
		parent::update($parameters);

		// scale preview image
		if(!empty($parameters['image']) && $parameters['image'] != $this->image){
			self::scalePreviewImage($parameters['image']);
		}
	}
}