<?php
namespace wbb\data\post\rating;

use wcf\data\DatabaseObject;
use wcf\system\WCF;

/**
 * Represents a post rating icon.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRating extends DatabaseObject{
	/**
	 * @see \wcf\data\DatabaseObject::$databaseTableName
	 */
	protected static $databaseTableName = 'post_rating';

	/**
	 * @see \wcf\data\DatabaseObject::$databaseIndexName
	 */
	protected static $databaseTableIndexName = 'ratingID';

	/**
	 * Defines the maximum height of graphic.
	 *
	 * @var integer
	 */
	const PREVIEW_IMAGE_MAX_HEIGHT = 16;

	/**
	 * Defines the maximum width of graphic.
	 *
	 * @var integer
	 */
	const PREVIEW_IMAGE_MAX_WIDTH = 16;


	/**
	 * Returns the title of this icon.
	 *
	 * @return string
	 */
	public function getTitle(){
		return WCF::getLanguage()->get($this->description);
	}

	/**
	 * Returns the icon preview image path.
	 *
	 * @return string
	 */
	public function getPreviewImage(){
		if($this->image && file_exists(WBB_DIR.$this->image)){
			return WCF::getPath('wbb').$this->image;
		}

		return WCF::getPath('wbb').'images/post/rating/ratingPreview.png';
	}
}
