-- wbb1_post_rating
DROP TABLE IF EXISTS wbb1_post_rating;
CREATE TABLE wbb1_post_rating (
  ratingID int(10) NOT NULL AUTO_INCREMENT,
  title varchar(255) NOT NULL,
  description varchar(255) DEFAULT '',
  image varchar(255) DEFAULT NULL,
  amount varchar(255) NOT NULL DEFAULT '0',
  isDisabled tinyint(1) NOT NULL DEFAULT '0',
  isFirstPost tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (ratingID)
);

-- wbb1_post_rating_to_post
DROP TABLE IF EXISTS wbb1_post_rating_to_post;
CREATE TABLE wbb1_post_rating_to_post (
  ratingID int(10) NOT NULL,
  postID int(10) DEFAULT NULL,
  userID int(10) DEFAULT NULL,
  UNIQUE KEY indexID (ratingID, postID,userID),
  KEY userID (userID),
  KEY ratingID (ratingID)
);

-- wbb1_post_rating_to_post
ALTER TABLE wbb1_post_rating_to_post ADD FOREIGN KEY (postID) REFERENCES wbb1_post (postID) ON DELETE CASCADE;
ALTER TABLE wbb1_post_rating_to_post ADD FOREIGN KEY (ratingID) REFERENCES wbb1_post_rating (ratingID) ON DELETE CASCADE;
ALTER TABLE wbb1_post_rating_to_post ADD FOREIGN KEY (userID) REFERENCES wcf1_user (userID) ON DELETE CASCADE;