WBB.ACP.PostRating = {};

/**
 * Handles the preview image upload.
 *
 * @param  integer    symbolID
 * @param  string    tmpHash
 */
WBB.ACP.PostRating.ImageUpload = WCF.Upload.extend({
    /**
     * upload button
     * @var  jQuery
     */
    _button: null,

    /**
     * preview image
     * @var  jQuery
     */
    _image: null,

    /**
     * symbol id
     * @var  integer
     */
    _postRatingID: 0,

    /**
     * tmp hash
     * @var  string
     */
    _tmpHash: '',

    /**
     * @see  WCF.Upload.init()
     */
    init: function (postRatingID, tmpHash) {
        this._postRatingID = parseInt(postRatingID) || 0;
        this._tmpHash = tmpHash;

        this._button = $('#uploadImage');
        this._image = $('#postRatingImage');

        this._super(this._button, undefined, 'wbb\\data\\post\\rating\\PostRatingAction');
    },

    /**
     * @see  WCF.Upload._initFile()
     */
    _initFile: function (file) {
        return this._image;
    },

    /**
     * @see  WCF.Upload._getParameters()
     */
    _getParameters: function () {
        return {
            postRatingID: this._postRatingID,
            tmpHash: this._tmpHash
        };
    },

    /**
     * @see  WCF.Upload._success()
     */
    _success: function (uploadID, data) {
        if (data.returnValues.url) {
            // show image
            this._image.attr('src', data.returnValues.url);
            $('input[name="fileName"]').val(data.returnValues.fileName);
            $('input[name="extension"]').val(data.returnValues.extension);

            // hide error
            this._button.next('.innerError').remove();

            // show success message
            var $notification = new WCF.System.Notification(WCF.Language.get('wcf.global.success'));
            $notification.show();
        }
        else if (data.returnValues.errorType) {
            // show error
            this._getInnerErrorElement().text(WCF.Language.get('wbb.acp.threadsAndPosts.post.rating.entry.columnData.error.' + data.returnValues.errorType));
        }

        WCF.DOMNodeInsertedHandler.execute();
    },

    /**
     * Returns error display element.
     *
     * @return  jQuery
     */
    _getInnerErrorElement: function () {
        var $span = this._button.next('.innerError');
        if (!$span.length) {
            $span = $('<small class="innerError" />').insertAfter(this._button);
        }

        return $span;
    }
});