<?php
namespace wbb\system\cache\builder;

use wbb\data\post\rating\ViewablePostRating;
use wcf\system\cache\builder\AbstractCacheBuilder;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Caches the post rating icons.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingCacheBuilder extends AbstractCacheBuilder{
	/**
	 * @see \wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
	 */
	protected $maxLifetime = 3600;


	/**
	 * @see \wcf\system\cache\AbstractCacheBuilder::rebuild()
	 */
	public function rebuild(array $parameters){
		$data = array('entry' => array(),'postToEntry' => array(), 'post' => array(), 'user' => array(), 'count' => array());

		// get all post ratinges
		$sql = 'SELECT post_rating.ratingID FROM wbb'.WCF_N.'_post_rating post_rating WHERE post_rating.isDisabled = 0';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while($row = $statement->fetchArray()){
			$data['entry'][$row['ratingID']] = ViewablePostRating::getViewablePostRating($row['ratingID']);
		}

		// get all post ratinges
		$sql = 'SELECT ratingID, postID, COUNT(*) as counter FROM wbb'.WCF_N.'_post_rating_to_post GROUP BY postID, ratingID';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while($row = $statement->fetchArray()){
			$data['postToEntry'][$row['postID']][$row['ratingID']] = $row['counter'];
		}

		// get all post ratinges
		$sql = 'SELECT COUNT(*) as maxCount, SUM(IF(rating.amount > 0,rating.amount, 0)) as positive, SUM(IF(rating.amount < 0,rating.amount, 0)) as negative, post.userID as userID FROM wbb'.WCF_N.'_post_rating_to_post rating_to_post
		LEFT JOIN wbb'.WCF_N.'_post_rating rating ON(rating.ratingID = rating_to_post.ratingID)
        LEFT JOIN wbb'.WCF_N.'_post post ON(post.postID = rating_to_post.postID)
		GROUP BY  post.userID';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while($row = $statement->fetchArray()){
			$data['user'][$row['userID']]['positive'] = $row['positive'];
			$data['user'][$row['userID']]['negative'] = str_replace('-', '', $row['negative']);
			$data['user'][$row['userID']]['maxPoints'] = $row['positive'] + str_replace('-', '', $row['negative']);
			$data['user'][$row['userID']]['max'] = $row['maxCount'];
		}

		// get all post ratinges
		$sql = 'SELECT rating_to_post.ratingID, rating_to_post.postID, rating_to_post.userID FROM wbb'.WCF_N.'_post_rating_to_post rating_to_post';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while($row = $statement->fetchArray()){
			$data['post'][$row['postID']]['user'][$row['userID']][$row['ratingID']] = ViewablePostRating::getViewablePostRating($row['ratingID']);
		}

		$sql = 'SELECT SUM(IF(rating.amount > 0,rating.amount, 0)) as positive, SUM(IF(rating.amount < 0,rating.amount, 0)) as negative, rating_to_post.postID
				FROM wbb'.WCF_N.'_post_rating_to_post rating_to_post
				LEFT JOIN wbb'.WCF_N.'_post_rating rating ON(rating.ratingID = rating_to_post.ratingID)
		GROUP BY  rating_to_post.postID';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while($row = $statement->fetchArray()){
			$data['count'][$row['postID']] = $row['positive'] - str_replace('-', '', $row['negative']);
		}

		return $data;
	}
}