<?php
namespace wbb\data\post\rating;

use wbb\system\cache\builder\PostRatingCacheBuilder;
use wcf\system\SingletonFactory;

/**
 * Manages the post rating icon cache.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingCache extends SingletonFactory{
	/**
	 * list of cached post rating icons
	 *
	 * @var array<\wbb\data\post\rating\PostRating>
	 */
	protected $postRatingsCached = array();


	/**
	 * Returns a list of all post rating icons.
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatings(){
		return $this->postRatingsCached['entry'];
	}

	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $userID
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatingsByUserID($userID){
		return isset($this->postRatingsCached['user'][$userID]) ? $this->postRatingsCached['user'][$userID] : null;
	}
	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $postID
	 *
	 * @return integer
	 */
	public function getPostRatingsCount($postID){
		return isset($this->postRatingsCached['count'][$postID]) ? $this->postRatingsCached['count'][$postID] : 0;
	}
	/**
	 * Returns the count of a rating object by given post id
	 *
	 * @param integer $postID
	 * @param integer $ratingID
	 *
	 * @return integer
	 */
	public function getPostRatingsRatingCount($postID, $ratingID){
		if(isset($this->postRatingsCached['postToEntry'][$postID])  && isset($this->postRatingsCached['postToEntry'][$postID][$ratingID]) ){
			return $this->postRatingsCached['postToEntry'][$postID][$ratingID];
		}
		return 0;
	}
	/**
	 * Returns a list of all post rating icons by given post id.
	 *
	 * @param integer $postID
	 *
	 * @return array<\wbb\data\post\rating\PostRating>
	 */
	public function getPostRatingsByPostID($postID){
		return isset($this->postRatingsCached['post'][$postID]) ? $this->postRatingsCached['post'][$postID] : null;
	}

	/**
	 * @see \wcf\system\SingletonFactory::init()
	 */
	protected function init(){
		$this->postRatingsCached = PostRatingCacheBuilder::getInstance()->getData();
	}
}