<?php
namespace wbb\acp\form;

use wbb\data\post\rating\PostRating;
use wbb\data\post\rating\PostRatingAction;
use wcf\data\package\PackageCache;
use wcf\form\AbstractForm;
use wcf\system\exception\IllegalLinkException;
use wcf\system\language\I18nHandler;
use wcf\system\WCF;

/**
 * Shows the post rating edit form.
 *
 * @author     Cyperghost
 * @copyright  2016 (C) by Cyperghost
 *
 * @package    de.wbb-elite.post.rating
 * @category   WoltLab Burning Board
 */
class PostRatingEditForm extends PostRatingAddForm{
	/**
	 * @see \wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'wbb.acp.menu.link.threadsAndPosts.postRatingList';

	/**
	 * @see \wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededPermissions = array('admin.content.canManagePostRating');

	/**
	 * post rating object
	 *
	 * @var \wbb\data\post\rating\PostRating
	 */
	public $postRating = null;

	/**
	 * post rating id
	 *
	 * @var integer
	 */
	public $postRatingID = 0;


	/**
	 * @see \wcf\page\IPage::assignVariables()
	 */
	public function assignVariables(){
		parent::assignVariables();

		I18nHandler::getInstance()->assignVariables(!empty($_POST));

		WCF::getTPL()->assign(array(
			'action'       => 'edit',
			'postRating'   => $this->postRating,
			'postRatingID' => $this->postRatingID
		));
	}

	/**
	 * @see \wcf\page\IPage::readData()
	 */
	public function readData(){
		parent::readData();

		if(empty($_POST)){
			I18nHandler::getInstance()->setOptions('description', PackageCache::getInstance()->getPackageID('com.woltlab.wbb'), $this->postRating->description, 'wbb.post.rating\d+');
			$this->title = $this->postRating->title;
			$this->description = $this->postRating->description;
			$this->isFirstPost = $this->postRating->isFirstPost;
			$this->amount = $this->postRating->amount;
		}
	}

	/**
	 * @see \wcf\page\IPage::readParameters()
	 */
	public function readParameters(){
		parent::readParameters();

		if(isset($_REQUEST['id'])) $this->postRatingID = intval($_REQUEST['id']);
		$this->postRating = new PostRating($this->postRatingID);
		if(!$this->postRating->ratingID){
			throw new IllegalLinkException();
		}
	}

	/**
	 * @see \wcf\form\IForm::save()
	 */
	public function save(){
		AbstractForm::save();

		// save description
		$this->description = 'wbb.post.rating'.$this->postRating->ratingID;
		if(I18nHandler::getInstance()->isPlainValue('description')){
			I18nHandler::getInstance()->remove($this->description, $this->postRatingID);
			$this->description = I18nHandler::getInstance()->getValue('description');
		}else{
			I18nHandler::getInstance()->save('description', $this->title, 'wbb.post', PackageCache::getInstance()->getPackageID('com.woltlab.wbb'));
		}

		$this->objectAction = new  PostRatingAction(array($this->postRating), 'update', array(
			'data'    => array_merge($this->additionalFields, array(
				'title'       => $this->title,
				'description' => $this->description,
				'isFirstPost' => $this->isFirstPost ? 1 : 0,
				'amount'      => $this->amount
			)),
			'tmpHash' => $this->tmpHash
		));
		$this->objectAction->executeAction();

		// call saved event
		$this->saved();

		// reload post rating object to update preview image
		$this->postRating = new PostRating($this->postRating->ratingID);

		// show success
		WCF::getTPL()->assign(array(
			'success' => true
		));
	}
}